'Chess!
''Chess:  Human Vs. Prop on XGA (1024x768 VGA)
'Copyright 2008-2009 Raymond Allen



CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000
  


  'for display
  cols = 64        'characters are 16 pixels wide
  rows = 48        '           and 32 pixels tall   (2 16-pixel rows per character)
  tiles = cols * rows
  display_base = $6000
  vga_params = 21

  'for chess
  BoardTileX =22 'board tile origins
  BoardTileY =11



  
VAR

  'variables for display
  long  col, row, color, flag
  word  boxptr
  byte boxcolor
  long  array[tiles/2]
  long  cursor_x, cursor_y', cursor_col, cursor_def
  long  sync                    



  'for Chess
  long CurrentSquare  'square that cursor is currently over (or -1 if none)
  'long LastSquare 'square cursor was last over
  long StartSquare 'square that move will start from
  long EndSquare 'square that move will go to
 
   


OBJ

  vga :  "VGA_1024x768_Tile_Driver_With_Cursor"   
  'kb : "keyboard"
  mouse : "mouse_wCursorASM5"
  board : "board6"



PUB main|i,j,m0,m1,m2,m3,pMove,sError,sCheck,bValid',s1,s2

  'start mouse
  'start mouse and set bound parameters
  mouse.start(19, 18, @array, @vgacolors,@vgacolors[16],@sync)          'use pins 24 and 25
    
  'start VGA
  vga.start(8, @array, @vgacolors, 0,@sync,0)
  out(0) 'clear screen

   'Draw Restart Button
   box(@Button1) 

  'start the keyboard
  'kb.start(26, 27)

  'title
  color:=0
  str(string($A,20,$B,2,"Chess:  Human Vs. Propeller"))

  'start chess objects
  board.start

  'init game
  board.init
  CurrentSquare:=-1  'mouse not over any board square
  StartSquare:=-1
  EndSquare:=-1
  DrawBoard
  
  'Play Chess
  repeat
  'White's Turn
    repeat
      ShowTurn
      'Get White's (Human) move
      WaitMouseDown
      WaitMouseUp
      color:=0
     
      
      mouse.suspendCursor
      if (CurrentSquare=>0)
        'user clicked on a square
        if (StartSquare<0)
          'make this the start square of a move in one hasn't been defined
          StartSquare:=CurrentSquare
          DrawSquare(StartSquare)
        else
          'Otherwise, this is the destination square
          EndSquare:=CurrentSquare
          DrawSquare(EndSquare)
          sError:=Board.MakeMove(StartSquare,EndSquare)
          StartSquare:=-1
          EndSquare:=-1
          if byte[sError][1]=="p"
            'Promotion:  Ask user what kind of promotion he would like
            sError:=0
          ShowTurn 
          ClearStatus
          row:=40
          col:=10
          str(board.GetPlayerString)
          sCheck:=0
          bValid:=false
          if sError==0      
            if (Board.ApplyMove==true)
              sError:=STRING(" made a valid move.")
              bValid:=true     
            else
              sError:=STRING(" attempted an illegal move!")
     
          'Show any error message
          row:=40
          col:=15
          str(sError)
     
          'update the board
          DrawBoard
     
          'Now look for check or checkmate/stalemate
          if bValid
            sCheck:=board.TestForCheck   
            'Show check status
            if sCheck<>0
              'Show check or checkmate/stalemate
              Row:=42
              col:=10
              str(sCheck)
            mouse.resumeCursor  
            quit
      else
        'See if clicked on a button
        i:=cursor_x>>4
        j:=(768-cursor_y)>>4
        if bInBox(@Button1, i, j)
          board.init
          ClearStatus 
     
        
        'user clicked off the board
        StartSquare:=-1
        EndSquare:=-1
        DrawBoard
      mouse.resumeCursor

    'Black's turn
    ShowTurn
    board.PickBestMove
    if not Board.ApplyMove
      row:=18
      col:=10
      str(string("Bad move..."))
    DrawBoard

    
PRI ClearStatus|i
  row:=40
  col:=0
  repeat i from 0 to 2*cols-1
    out(32)
  


PRI ShowTurn  
    row:=5
    col:=10
    str(board.GetPlayerString)
    str(string("'s Turn"))    
  

PRI WaitMouseDown|i,j   
  'update mouse until click-down
  repeat until mouse.button(0)  'until left-button down
    UpdateMouse
    row:=10
    col:=4


PRI WaitMouseUp
  repeat until !mouse.button(0)     'wait until left button released
    UpdateMouse  
                   
PRI UpdateMouse|x,y,Square,LastSquare          
  'update mouse position
  'first see if mouse has moved
  if ((cursor_x <> mouse.abs_x)|(cursor_y <> mouse.abs_y))
    'mouse has moved
    cursor_x := mouse.abs_x'bound_x
    cursor_y := mouse.abs_y'bound_y
    'see if over a new board square
    x:=(cursor_x>>4-BoardTileX)/3
    y:=(rows-1-cursor_y>>4-BoardTileY)/3
    if x<0 or x>7 or y<0 or y>7
      Square:=-1
    else
      Square:=y*8+x
    if Square<>CurrentSquare
      'on a new square
      LastSquare:=CurrentSquare
      CurrentSquare:=Square

 
PRI DrawSquare(Square)|i,j,c,p
  'redraw single square with optional effects
  if Square<0
    'illegitimate square
    return  
  j:=Square/8
  i:=Square//8
  c:=11+(j+i)//2   'color
  p:=board.GetSquareBitmap(square)
  if EndSquare==square 
    Bitmap2Bit(p, i*3+BoardTileX, j*3+BoardTiley, 3, 3, 15)
  elseif StartSquare==square
    Bitmap2Bit(p, i*3+BoardTileX, j*3+BoardTiley, 3, 3, 14)
  'elseif CurrentSquare==square
  '  Bitmap2Bit(p, i*3+BoardTileX, j*3+BoardTiley, 3, 3, 13)
  else      
    Bitmap2Bit(p, i*3+BoardTileX, j*3+BoardTiley, 3, 3, c)  'Highlight Square that mouse is over
    

PRI DrawBoard|i',j',k,c,p,square
  'redraw entire board
  repeat i from 0 to 63
    DrawSquare(i)

  'draw border
  repeat i from 0 to 23
     'j:=BoardTileY-1
     Bitmap2Bit(board.GetBorderBitmap(0), i+BoardTileX, BoardTiley-1, 1, 1, 11)
     Bitmap2Bit(board.GetBorderBitmap(2), i+BoardTileX, BoardTiley+24, 1, 1, 11)
     Bitmap2Bit(board.GetBorderBitmap(1), BoardTileX+24, BoardTiley+i, 1, 1, 11)
     Bitmap2Bit(board.GetBorderBitmap(3), BoardTileX-1, BoardTiley+i, 1, 1, 11)
  repeat i from -1 to 24
     Bitmap2Bit(board.GetBorderBitmap(0), i+BoardTileX, BoardTiley-2, 1, 1, 12)
     Bitmap2Bit(board.GetBorderBitmap(2), i+BoardTileX, BoardTiley+25, 1, 1, 12)
     Bitmap2Bit(board.GetBorderBitmap(1), BoardTileX+25, BoardTiley+i, 1, 1, 12)
     Bitmap2Bit(board.GetBorderBitmap(3), BoardTileX-2, BoardTiley+i, 1, 1, 12)

  Bitmap2Bit(board.GetBorderBitmap(4), BoardTileX-1, BoardTiley-1, 1, 1, 11)
  Bitmap2Bit(board.GetBorderBitmap(5), BoardTileX+24, BoardTiley-1, 1, 1, 11)
  Bitmap2Bit(board.GetBorderBitmap(7), BoardTileX-1, BoardTiley+24, 1, 1, 11)
  Bitmap2Bit(board.GetBorderBitmap(6), BoardTileX+24, BoardTiley+24, 1, 1, 11)
     
  Bitmap2Bit(board.GetBorderBitmap(4), BoardTileX-2, BoardTiley-2, 1, 1, 12)
  Bitmap2Bit(board.GetBorderBitmap(5), BoardTileX+25, BoardTiley-2, 1, 1, 12)
  Bitmap2Bit(board.GetBorderBitmap(7), BoardTileX-2, BoardTiley+25, 1, 1, 12)
  Bitmap2Bit(board.GetBorderBitmap(6), BoardTileX+25, BoardTiley+25, 1, 1, 12)  
  

PRI str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])


PRI dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    out("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      out(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      out("0")
    i /= 10


PRI hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    out(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PRI bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    out((value <-= 1) & 1 + "0")


PRI out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $05 = USER 1-BIT CHARACTER
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: 'Mouse.SuspendCursor
                wordfill(@array, $8000 + $20 << 6, tiles)
                col := row := 0
                'Mouse.ResumeCursor
           $01: col := row := 0
           $05: flag:=c
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
  flag := 0


PRI print(c) |i,k
  k := color << 1 + c & 1
  i := $8000 + (c & $FE) << 6 + k
  'Mouse.SuspendCursor
  array.word[row * cols + col] := i'(color << 1 + c & 1) << 10 + $200 + c & $FE
  array.word[(row+1) * cols + col] :=i|$40':= (color << 1 + c & 1) << 10 + $200 + c & $FE +1
  'Mouse.ResumeCursor 
  if ++col == cols
    newline

Pri bInBox(pButton, x, y):bOnButton| left, top, right, bottom, pstr
  'test if x and y are on a button
  left:=Byte[pButton][0]
  top:=Byte[pButton][1]
  pstr:=pButton+2

  right := left+strsize(pstr)+1
  bottom:=top+3

  if x=>left and x=<right
    if y=>top and y=<bottom
      return true

  return false
    
PRI box(pButton)| left, top, pstr, width, height, x, y, i

' Draw a box
  left:=Byte[pButton][0]
  top:=Byte[pButton][1]
  pstr:=pButton+2
  

  boxcolor := 10'$10 + clr
  color := 4'clr + 5

  width := strsize(pstr)
  height := 2

  boxptr := top * cols + left
  boxchr($0)
  repeat i from 1 to width
    boxchr($C)
  boxchr($8)
  repeat i from 1 to height
    boxptr := (top + i) * cols + left
    boxchr($A)
    boxptr += width
    boxchr($B)
  boxptr := (top + height + 1) * cols + left
  boxchr($1)
  repeat i from 1 to width
    boxchr($D)
  boxchr($9)

  col := left + 1
  row := top + 1
  str(pstr)
  

PRI boxchr(c): i

  array.word[boxptr++] := $8000 + c << 6 + boxcolor




PRI Bitmap2Bit(pBitmap, xPos, yPos, xSize, ySize, clr)|c,i,j,BmpAddress
  row:=yPos
  col:=xPos
  c:=0
  'BmpAddress:=pBitmap+user_charbase-@uchar
  'Mouse.SuspendCursor
  repeat j from 0 to (ySize-1)
    repeat i from 0 to (xSize-1)
      array.word[row * cols + col] := pBitmap + (c<<6)  + clr
      c++
      col++
    row++
    col:=xPos
  'Mouse.ResumeCursor  
  


PRI newline | i

  col := 0
  if (row += 2) == rows
    'Mouse.SuspendCursor
    row -= 2
    'scroll lines
    repeat i from 0 to rows-3
      wordmove(@array.word[i*cols], @array.word[(i+2)*cols], cols)
    'clear new line
    wordfill(@array.word[(rows-2)*cols], $8000 + $20 << 6, cols<<1)
    'Mouse.ResumeCursor


DAT

'Chess data

Button1 byte
        byte 53
        byte 33
        byte "Restart",0  

  'input to TV driver

  
tv_params long
                        long    0               'status
                        long    1               'enable
tv_pins                 long    0               'pins
                        long    %00010          'mode        (%00000 NON-INTERLACED, %00010 FOR INTERLACED)
tv_screen               long    0               'screen
tv_colors               long    0               'colors
                        long    cols            'hc
                        long    rows            'vc
                        long    4               'hx           (9 for 20)
                        long    1               'vx          (1 NON-INTERLACED 14, 2 FOR INTERLACED 14)
                        long    0               'ho
                        long    0               'vo
                        long    0               'broadcast
                        long    0               'auralcog



 vgacolors long

'0..1:  text color 0:  
  long $F010F010        '0: Yellow on Green  
  long $F0F01010 
'2..3:  text color 1: 
  long $C0FCC0FC       ' red on white   
  long $C0C0FCFC
'4..5:  text color 2:        
  long $00FC00FC       'black on white  
  long $0000FCFC 
'6..7:  text color 3:     
  long $F010F010        '3: Yellow on Green  
  long $F0F01010 
'8..9:  text color 4:    
  long $00540054'$00A800A8      '4: black on grey  for box
  long $00005454'$0000A8A8 
'10:  graphics 0:  
  long $FC005454'$FF00A8A8         'box color gray  
'11:  graphics 1:  'light square   
  long %%3330_0000_0100_2100 '%%2100_2220_0100_0000         ' 
'12:  graphics 2:  'dark square
  long %%3330_0000_0100_1000        '  
'13:  graphics 3:  'highlight square
  long %%3330_0000_0100_1030        '
'14:  graphics 4:  'Start square
  long %%3330_0000_0100_3300        '
'15:  graphics 5:  'End square
  long %%3330_0000_0100_0330        '
'16:  cursor
        'long 0[4]
  long %%3300_2220_0100_0000
  long %%3300_2220_0100_0000
  long %%3300_2220_0100_0000
  long %%3300_2220_0100_0000
'21:  border

           
